Attribute VB_Name = "AddTable"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 2000 Parametric Technology Corporation.
'       All rights reserved.
'
'       Files: AddTable.bas, AddTableDlg.frm, AddTableDlg.frx
'
'       This is an example of how to create a general purpose table.
'       AddTableDlg allows you to enter certain properties of the table,
'       such as the number of rows and columns, the title if any, and a
'       corner of the drawing at which to place the table. Other properties
'       are hard coded for simplicity, such as the column widths.

Option Explicit
Private app As ProDESKTOP

Public Sub AddTable()
    Set app = GetApp
    app.SetVisible True

    On Error Resume Next
    Dim drawingDoc As DrawingDocument
    Set drawingDoc = app.GetActiveDoc
    If drawingDoc Is Nothing Then
        MsgBox "There is no active drawing document", vbInformation
        Exit Sub
    End If
    On Error GoTo 0

    AddTableDlg.Show
End Sub

Public Sub CreateTable(sheet As aSheet, pos As zVector, anchor As Integer, Title As String, nColumns As Integer, nRows As Integer, Inverted As Boolean, EmptyCells As Boolean)
    Set app = GetApp
    
    Dim textHeight As Double
    textHeight = 0.005  '5mm

    Dim columnWidth As Double
    columnWidth = 0.05  '50mm

    Dim api As helm
    Set api = app.TakeHelm

    Dim table As aTable
    Set table = app.GetClass("Table").CreateTable(pos, textHeight, nColumns, columnWidth, alignCenter)

    sheet.AddTable table

    table.SetInverted Inverted

    table.SetAnchor anchor
    table.SetAnchorPoint anchor, pos

    Dim i As Integer
    For i = 0 To nRows - 1
        InsertRow table, -1, EmptyCells
    Next

    Dim baseIndex As Long, indent As Long
    baseIndex = 0
    indent = 0
    
    If Title <> "" Then
        indent = 1
        table.SetIndent 0, indent
        table.SetTitle 0, Title
        baseIndex = 1
    End If

    For i = 0 To nColumns - 1
        table.SetIndent baseIndex + i, indent
        table.SetTitle baseIndex + i, "Column" + str(i + 1)
    Next

    api.CommitCalls "Create Table", False
End Sub

Private Sub InsertRow(table As aTable, before As Long, EmptyCells As Boolean)
    table.InsertRow before
    
    If EmptyCells Then Exit Sub

    Dim row As Long
    If before < 0 Then
        row = table.GetRowCount - 1
    Else
        row = before
    End If

    Dim nodes As Long
    nodes = table.GetNodeCount

    Dim column As Long
    For column = 0 To nodes - 1
        Dim tableColumn As aTableColumn
        Set tableColumn = table.GetColumn(column)
        
        Dim tableCell As aTableCell
        Set tableCell = tableColumn.GetCell(row)

        CreateNote table, tableCell, "Cell" + str(column + 1) + str(row + 1)
    Next
End Sub

Private Sub CreateNote(table As aTable, tableCell As aTableCell, text As String)
    Dim note As aNote
    Set note = app.GetClass("Note").CreateNote(table.GetParent("Drawing"), text)
    
    Dim noteCallout As aNoteCallout
    Set noteCallout = app.GetClass("NoteCallout").CreateNoteCallout(note)

    Dim origin As zVector
    Set origin = app.GetClass("Vector").CreateVector(0, 0, 0)
    
    Dim calloutGroup As aCalloutGroup
    Set calloutGroup = app.GetClass("CalloutGroup").CreateCalloutGroup(noteCallout, origin, table.GetTextHeight)
    
    tableCell.SetCalloutGroup calloutGroup
End Sub

